******************************************************************************************************************
* Disability employment results WITHOUT bootstrap
* This can't do PPWD (without getting SUEST to work), nor the full randomness for predicted dis - but otherwise correct
* Started 28/6/2023
******************************************************************************************************************

local measures "${disvar} ${IRTvar} ${predictedvar}_fxd ${predictedvar} "

// The analysis
foreach measure in `measures' {
	* Need to exclude this for England/UK, which has no self-reported LLSI data in ELSA
	if "`measure'"=="${disvar}"		local thisif = "if countrynum!=30"
	if "`measure'"!="${disvar}"		local thisif = "if countrynum!=99"		// needs to be an if command here so that can be added too, but this doesn't exclude anyone
	
	* Models 1 - DISABILITY differences betweeen surveys
	eststo d1_`measure'		: logit `measure'  (i.${countryvar}				$controls $controls2)##i.elsashare `thisif' 				 [pw=${pweight}]
		testparm i.countrynum#1.elsashare		// check against the joint sig test of margins below
			estadd scalar alltest_p 	= `r(p)'		: d1_`measure'
		eststo dMr_`measure' :	margins r.elsashare@${countryvar}, 				 	 at(${controlsmeans}) post		// ${eurpop} taken out
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: dMr_`measure'			// for joint significance
	
	* Models 2 - the levels in each survey in each country
	eststo dEHIS_`measure'		: logit `measure'  i.${countryvar}						$controls $controls2 `thisif' & elsashare==0 [pw=${pweight}]
		eststo dMEHIS_`measure' :	margins i.${countryvar}, 				 at(${controlsmeans}) post				// ${eurpop} taken out
	eststo dELSA_`measure'		: logit `measure'  i.${countryvar}						$controls $controls2 `thisif' & elsashare==1 [pw=${pweight}]
		eststo dMELSA_`measure' :	margins i.${countryvar}, 				 at(${controlsmeans}) post				// ${eurpop} taken out
	
	* Models 3 - DIS EMPLOYMENT differences between surveys
	eststo e3_`measure'		: logit ${empvar}  ib(1).`measure'##i.elsashare##i.${countryvar} $controls $controls2 i.elsashare#($controls $controls2) `thisif' [pw=${pweight}]
		testparm i.countrynum#i.`measure'#i.elsashare // check against the joint sig test of margins below
			estadd scalar alltest_p 	= `r(p)'		: e3_`measure'
		eststo eMrr_`measure':	margins r.`measure'#r.elsashare@${countryvar}, 		 at(${controlsmeans}) post		// ${eurpop} taken out
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: eMrr_`measure'		// for joint significance
	// ABSOLUTE DISEMP
	estimates restore e3_`measure'
		eststo eMer_`measure':	margins r.elsashare@1.`measure'#${countryvar}, 		 at(${controlsmeans}) post		// ${eurpop} taken out
			estadd scalar jointsig = e(p)[1,colsof(e(p))]		: eMer_`measure'		// for joint significance
	estimates restore e3_`measure'
		proportion `measure' if e(sample) [pw=${pweight}]
			scalar disn	   = e(freq)[1,2]				
			estimates restore eMer_`measure'
			estadd scalar disn	   = disn 				: eMer_`measure'		// sample size of disabled people

	* Models 4 - DIS EMPLOYMENT absolute levels split by country
	eststo eEHIS_`measure'		: logit ${empvar}  ib(1).`measure'##i.${countryvar} 			$controls $controls2 `thisif' & elsashare==0  [pw=${pweight}]
		eststo eMiEHIS_`measure':	margins i.`measure', over(${countryvar}) at(${controlsmeans}) post				// ${eurpop} taken out
		estimates restore eEHIS_`measure'
			proportion `measure' if e(sample) [pw=${pweight}]
				scalar disn	   = e(freq)[1,2]				
				estimates restore eMer_`measure'
				estadd scalar disn	   = disn 				: eMiEHIS_`measure'		// sample size of disabled people
		estimates restore eEHIS_`measure'
			eststo eMrEHIS_`measure':	margins r.`measure'@${countryvar}, 		 at(${controlsmeans}) post				// ${eurpop} taken out
	eststo eELSA_`measure'		: logit ${empvar}  ib(1).`measure'##i.${countryvar} 			$controls $controls2 `thisif' & elsashare==1  [pw=${pweight}]
		eststo eMiELSA_`measure':	margins i.`measure', over(${countryvar}) at(${controlsmeans}) post				// ${eurpop} taken out
		estimates restore eELSA_`measure'
			proportion `measure' if e(sample) [pw=${pweight}]
				scalar disn	   = e(freq)[1,2]				
				estimates restore eMer_`measure'
				estadd scalar disn	   = disn 				: eMiELSA_`measure'	// sample size of disabled people

		estimates restore eELSA_`measure'
			eststo eMrELSA_`measure':	margins r.`measure'@${countryvar}, 		 at(${controlsmeans}) post				// ${eurpop} taken out
	
	* NOTE: this all uses over($countryvar), which is different to 5_results_bootstrap.do. Will produce the same results unless the covariates are not set to fixed values in 'at'.
/**/							}


// The tables
label define fullcountry 1 Austria 6 Germany 27 Sweden 17 Italy 12 France 7 Denmark 9 Greece 5 Czechia 24 Poland 28 Slovenia 8 Estonia 30 England, replace
	local oldlabel: value label $countryvar
	label values ${countryvar} fullcountry
levelsof ${countryvar}
foreach country in `r(levels)'	{
	* Renaming the variables from four equations so that they display in the same rows
	local countrylab: label (${countryvar}) `country'
	local countrylab = subinstr("`countrylab'", " ", "_", .)		// estttab, rename() doesn't work with spaces, so need to remove this, and use the 'varlabels' option to insert the space back in
	local rename_eMrr `"`rename_eMrr' r1vs0.${disvar}#r1vs0.elsashare@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${IRTvar}#r1vs0.elsashare@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${predictedvar}_fxd#r1vs0.elsashare@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMrr `"`rename_eMrr' r1vs0.${predictedvar}#r1vs0.elsashare@`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r1vs0.elsashare@1.${disvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r1vs0.elsashare@1.${IRTvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r1vs0.elsashare@1.${predictedvar}_fxd#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMer `"`rename_eMer' r1vs0.elsashare@1.${predictedvar}#`country'.${countryvar}  "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${disvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${IRTvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eMr `"`rename_eMr' r1vs0.${predictedvar}_fxd@`country'.${countryvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${disvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${IRTvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar} "`countrylab'" "'
	local rename_eMi `"`rename_eMi' `country'.${countryvar}#1.${predictedvar}_fxd "`countrylab'" "'
	local rename_dM  `"`rename_dM' `country'.${countryvar} "`countrylab'" "'
	local rename_dMr `"`rename_dMr' r1vs0.elsashare@`country'.${countryvar} "`countrylab'" "'
/**/							}
label values ${countryvar} `oldlabel'
* The ESTTAB command
global esttabopts `"nostar b(%3.1f) ci(%3.1f) transform(@*100 100) varwidth(20) modelwidth(8 15 8 15 8 15 8 15)"'
global esttabopts `"${esttabopts} varlabels("UK" "UK(EHIS)/England(ELSA)") coeflabels(`labels') nonum replace nolegend nobaselevels wide"'
*global esttabopts `"${esttabopts} order("Liberal" UK "Social Democratic A" DK "Social Democratic B" DE SE "Corporatist-A" AT "Corporatist-C" CZ SI "Southern" IT EL "Other" EE)"' 
global esttabopts `"${esttabopts} addnotes("Table created on `c(current_date)'" "INSTRUCTIONS FOR FORMATTING: headings into bold, change font & size, reduce size for CI cols, merge titles, remove internal margins, then double-click to reduce width of cols, under table style")"'
global mtitles 		`"mtitles(LLSI Factor "Predicted (fixed)" "Predicted (random)")  mgroups("Observed" "Alternative measures", pattern(1 1 0 0))"'			 
* Outputting to Word tables
esttab dMELSA_${disvar}  dMEHIS_${disvar}  dMr_${disvar}  using "${dodir}\Outputs\1.nonbootstrap_disRbysurveyV2.rtf", ${esttabopts} mtitles("ELSA" "EHIS" "Difference") rename(`rename_dMr' `rename_dM') title("Disability rate") scalars("jointsig Combined test of differences") sfmt(%5.4f) order(Greece Italy Denmark Sweden France Austria Czechia Slovenia Germany Poland Estonia)
esttab eMiELSA_${disvar} eMiEHIS_${disvar} eMer_${disvar} using "${dodir}\Outputs\1.nonbootstrap_empMbysurveyV2.rtf", ${esttabopts} mtitles("ELSA" "EHIS" "Difference") rename(`rename_eMer' `rename_eMi') title("Disability employment rate") drop(*0.${disvar}*) scalars("disn N (disabled people)" "jointsig Combined test of differences") sfmt(%7.0f %5.4f) order(Sweden Estonia Germany Denmark France Czechia Italy Austria Greece Slovenia Poland)
esttab eMrELSA_${disvar} eMrEHIS_${disvar} eMrr_${disvar} using "${dodir}\Outputs\1.nonbootstrap_empRbysurveyV2.rtf", ${esttabopts} mtitles("ELSA" "EHIS" "Difference") rename(`rename_eMrr' `rename_eMr') title("Disability employment gap") scalars("jointsig Combined test of differences") sfmt(%5.4f ) order(Slovenia Italy Greece France Sweden Germany Austria Estonia Denmark Poland)
esttab eMrELSA_* using "${dodir}\Outputs\1.nonbootstrap_empR_ELSA.rtf", ${esttabopts} ${mtitles} rename(`rename_eMr' ) title("Disability employment gap (ELSA-SHARE)")
esttab eMiELSA_* using "${dodir}\Outputs\1.nonbootstrap_empM_ELSA.rtf", ${esttabopts} ${mtitles} rename(`rename_eMi' ) title("Disability employment rate (ELSA-SHARE)") drop (*0.${disvar}*)
esttab eMrEHIS_* using "${dodir}\Outputs\1.nonbootstrap_empR_EHIS.rtf", ${esttabopts} ${mtitles} rename(`rename_eMr' ) title("Disability employment gap (EHIS)")
esttab eMiEHIS_* using "${dodir}\Outputs\1.nonbootstrap_empM_EHIS.rtf", ${esttabopts} ${mtitles} rename(`rename_eMi' ) title("Disability employment rate (EHIS)") drop (*0.${disvar}*)
esttab dMELSA_*  using "${dodir}\Outputs\1.nonbootstrap_disR_ELSA.rtf", ${esttabopts} ${mtitles} rename(`rename_dM'  ) title("Disability rate (ELSA-SHARE)")
esttab dMEHIS_*  using "${dodir}\Outputs\1.nonbootstrap_disR_EHIS.rtf", ${esttabopts} ${mtitles} rename(`rename_dM'  ) title("Disability rate (EHIS)")
esttab dMr_*  	 using "${dodir}\Outputs\1.nonbootstrap_disRsurvey.rtf"	  , ${esttabopts} ${mtitles} rename(`rename_dMr' ) title("Survey differences in disability rate")			  	scalars(jointsig) sfmt(%5.4f)
esttab eMrr_* 	 using "${dodir}\Outputs\1.nonbootstrap_empRsurvey.rtf"	  , ${esttabopts} ${mtitles} rename(`rename_eMrr') title("Survey differences in disability employment gap") 	scalars(jointsig) sfmt(%5.4f)
esttab eMer_* 	 using "${dodir}\Outputs\1.nonbootstrap_empMsurvey.rtf"	  , ${esttabopts} ${mtitles} rename(`rename_eMer') title("Survey differences in disability employment rate") 	scalars(jointsig) sfmt(%5.4f)
/* Outputting to Tab-delimited for importing into Excel
esttab eMr_* using "${dodir}\Outputs\1.nonbootstrap_empR.tab", ${esttabopts} rename(`rename_eMr' ) title("Disability employment gap")
esttab eMi_* using "${dodir}\Outputs\1.nonbootstrap_empM.tab", ${esttabopts} rename(`rename_eMi' ) title("Disability employment rate") drop (*0.${disvar}*)
esttab dM_*  using "${dodir}\Outputs\1.nonbootstrap_disR.tab" , ${esttabopts} rename(`rename_dM' ) title("Disability rate")
*/

* For sample sizes of disabled people
tab countrynum elsashare if llsiB!=1

